globals [
  sky-top      ;; y souadnice pro nejvy dek oblohy
  earth-top    ;; y souadnice pro nejvy dek zem
  temperature  ;; celkov teplota
]

breed [rays ray]     ;; jednotka slunenho zen
breed [IRs IR]       ;; jednotka infraervenho zen
breed [heats heat]   ;; jednotka tepeln energie
breed [CO2s CO2]     ;; jednotka oxidu uhliitho

breed [clouds cloud]
clouds-own [cloud-speed cloud-id]

;;
;; Procedury tlatka Piprav
;;

to setup
  clear-all
  set-default-shape rays "ray"
  set-default-shape IRs "ray"
  set-default-shape clouds "cloud"
  set-default-shape heats "dot"
  set-default-shape CO2s "CO2-molecule"
  setup-world
  set temperature 12
  plot temperature
end

to setup-world
  set sky-top max-pycor - 5
  set earth-top 0
  ask patches [  ;; rznm stem svta piad odpovdajc barvy
    if pycor > sky-top [  ;; vesmr
      set pcolor scale-color white pycor 22 15
    ]
    if pycor <= sky-top and pycor > earth-top [ ;; nebe
      set pcolor scale-color blue pycor -20 20
    ]
    if pycor < earth-top
      [ set pcolor red + 3 ] ;; zem
    if pycor = earth-top ;; zemsk povrch
      [ update-albedo ]
  ]
end

;;
;; Procedury tlatka Start
;;

to go
  ask clouds [ fd cloud-speed ]  ; rozpohybuje mraky
  run-sunshine   ;; slunen svit
  ;; pokud se zmnila hodnota posuvnku ALBEDO, pebarv se zemsk povrch odpovdajcm odstnem
  ask patches with [pycor = earth-top]
    [ update-albedo ]
  run-heat  ;; teplo
  run-IR    ;; infraerven svtlo
  run-CO2   ;; CO2 molekuly
  tick
  plot temperature
end

to update-albedo ;; procedura polek
  set pcolor scale-color green albedo 0 1
end

to add-cloud   ;; vymae vechny mraky a vytvo je znovu v potu vym o jedna
  let sky-height sky-top - earth-top
  ;; vybere pro mrak nhodnou vku, ale nejdve
  ;; zkontroluje, zda se vbec jedn o prostor oblohy 
  let y earth-top + (random-float (sky-height - 4)) + 2
  ;; dn mrak by neml mt nulovou rychlost
  let speed (random-float 0.1) + 0.01
  let x random-xcor
  let id 0
  ;; nezajm ns identifikace jednotlivch elv v jednom mraku, 
  ;; proto v jednom shluku (mraku) maj elvy stejn id. Naopak kad 
  ;; z mrak m svoje jedinen identifikan slo.
  if any? clouds
  [ set id max [cloud-id] of clouds + 1 ]

  create-clouds 3 + random 20
  [
    set cloud-speed speed
    set cloud-id id
    ;; vechny elvy tvoc mrak by mly bt blzko sebe,
    ;; ale zrove se nesm pln pekrvat. Proto je pro mrak
    ;; vymezena vhodn oblast pomoc souadnic x,y.
    setxy x + random 9 - 4
          ;; mraky by se mly s jistou odchylkou
          ;; shlukovat kolem jedinho centra
          y + random-normal 2.5 1
    set color white
    ;; rozdln velikost je urena pouze pro vizuln efekt,
    ;; jeliko ke kolizm dochz pouze na rovni polek
    set size 2 + random 2
    set heading 90
  ]
end

to remove-cloud       ;; vymae vechny mraky a vytvo je znovu v potu nim o jedna
  if any? clouds [
    let doomed-id one-of remove-duplicates [cloud-id] of clouds
    ask clouds with [cloud-id = doomed-id]
      [ die ]
  ]
end

to run-sunshine
  ask rays [
    if not can-move? 0.3 [ die ]  ;; zni paprsky na okrajch
    fd 0.3                        ;; ostatn uvede do pohybu
  ]
  create-sunshine  ;; zane z horn asti vypoutt slunen paprsky 
  reflect-rays-from-clouds  ;; zkontroluje odraz paprsk od mrak
  encounter-earth    ;; zkontroluje odraz od povrchu zem a absorbci tepla
end

to create-sunshine
  ;; v kadm asovm kroku nemus nutn vzniknout nov paprsek, avak
  ;; s rostouc intenzitou slunenho zen se vytv paprsk vce
  if 10 * slunecni-zareni > random 50 [
    create-rays 1 [
      set heading 160
      set color yellow
      ;; paprsky vychz z relativn mal oblasti
      ;; pobl hornho okraje svta
      setxy (random 10) + min-pxcor max-pycor
    ]
  ]
end

to reflect-rays-from-clouds
 ask rays with [any? clouds-here] [   ;; pokud se na stejnm polku setkaj paprsek a mrak,
   set heading 180 - heading   ;; pak se oto smr paprsku
 ]
end

to encounter-earth
  ask rays with [ycor <= earth-top] [
    ;; v zvislosti na hodnot promnn ALBEDO zem 
    ;; bu teplo absorbuje a nebo jej odraz
    ifelse 100 * albedo > random 100
      [ set heading 180 - heading  ] ;; odraz
      [ rt random 45 - random 45 ;; absorbce do zem
        set color red - 2 + random 4
        set breed heats ]
  ]
end

to run-heat    ;; zaloeno na elvch reprezentujcch tepelnou energii
  ;; teplota je zvisl na potu tchto elv
  set temperature 0.99 * temperature + 0.01 * (12 + 0.1 * count heats)
  ask heats
  [
    let dist 0.5 * random-float 1
    ifelse can-move? dist
      [ fd dist ]
      [ set heading 180 - heading ] ;; pokud naraz na okraj svta, obrt se
    if ycor >= earth-top [  ;; pokud m smrem do nebe
      ifelse temperature > 20 + random 40
              ;; teplo (ve form IR paprsk) me prosakovat ze zem pouze na 
              ;; omezen ploe, co sice pispv k vizuln kvalit modelu,
              ;; ale na druh stran to zkresluje mru tepeln ztrty 
              and xcor > 0 and xcor < max-pxcor - 8
        [ set breed IRs                    ;; vypust IR paprsky
          set heading 20
          set color magenta ]
        [ set heading 100 + random 160 ] ;; vrac zpt k zemi
    ]
  ]
end

to run-IR
  ask IRs [
    if not can-move? 0.3 [ die ]
    fd 0.3
    if ycor <= earth-top [   ;; pokud se paprsek opt dotkne povrchu, pemn IR svtlo v jednotku tepla
      set breed heats
      rt random 45
      lt random 45
      set color red - 2 + random 4
    ]
    if any? CO2s-here    ;; zkontroluje srky s CO2
      [ set heading 180 - heading ] ;; obrac paprsek
  ]
end

to add-CO2  ;; nhodn pid do atmosfry 25 molekul CO2
  let sky-height sky-top - earth-top
  create-CO2s 25 [
    set color green
    ;; zabere nhodn msto na obloze
    setxy random-xcor
          earth-top + random-float sky-height
  ]
end

to remove-CO2 ;; nhodn odstran z atmosfry 25 molekul CO2
  repeat 25 [
    if any? CO2s [
      ask one-of CO2s [ die ]
    ]
  ]
end

to run-CO2
  ask CO2s [
    rt random 51 - 25 ;; o kousek pooto molekulu CO2
    let dist 0.05 + random-float 0.1
    ;; zadr molekuly CO2 na ploe znzorujc atmosfru
    if [not shade-of? blue pcolor] of patch-ahead dist
      [ set heading 180 - heading ]
    fd dist ;; posune molekulu v danm smru
  ]
end


; *** NetLogo 4.0.3 Model Copyright Notice ***
;
; Copyright 2007 by Uri Wilensky.  All rights reserved.
;
; Permission to use, modify or redistribute this model is hereby granted,
; provided that both of the following requirements are followed:
; a) this copyright notice is included.
; b) this model will not be redistributed for profit without permission
;    from Uri Wilensky.
; Contact Uri Wilensky for appropriate licenses for redistribution for
; profit.
;
; To refer to this model in academic publications, please use:
; Tinker, R. and Wilensky, U. (2007). NetLogo Climate Change model.
; http://ccl.northwestern.edu/netlogo/models/ClimateChange.
; Center for Connected Learning and Computer-Based Modeling,
; Northwestern University, Evanston, IL.
;
; In other publications, please use:
; Copyright 2007 Uri Wilensky.  All rights reserved.
; See http://ccl.northwestern.edu/netlogo/models/ClimateChange
; for terms of use.
;
; *** End of NetLogo 4.0.3 Model Copyright Notice ***
@#$#@#$#@
GRAPHICS-WINDOW
327
11
876
383
24
-1
11.0
1
10
1
1
1
0
1
0
1
-24
24
-8
22
1
1
1
ticks

CC-WINDOW
5
437
885
532
Command Center
0

BUTTON
6
12
101
45
Piprav
Setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL

BUTTON
103
12
198
45
Start
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL

SLIDER
18
47
191
80
slunecni-zareni
slunecni-zareni
0
5
1
0.2
1
NIL
HORIZONTAL

SLIDER
18
82
191
115
albedo
albedo
0
1
0.6
0.05
1
NIL
HORIZONTAL

PLOT
9
212
278
423
Teplota zem
NIL
NIL
0.0
10.0
10.0
20.0
true
false
PENS
"default" 1.0 0 -2674135 true

BUTTON
7
153
102
187
Pidej CO2
add-CO2
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL

BUTTON
107
154
213
187
Odstra CO2
remove-CO2
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL

MONITOR
218
85
311
130
Teplota
temperature
1
1
11

BUTTON
7
118
102
151
Pidej mrak
add-cloud
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL

BUTTON
107
118
213
151
Odstra mrak
remove-cloud
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL

MONITOR
218
131
311
176
Mnostv CO2
count CO2s
2
1
11

BUTTON
208
41
320
75
Sleduj paprsek
watch one-of rays\nask subject [ pd ]
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL

@#$#@#$#@
CO TO JE?
-----------
Toto je model toku tepeln energie v zemsk ke. Rov barva reprezentuje masu Zem, povrch planety je znzornn zelenm psem. Nad tmto psem je modr atmosfra a zcela nahoe se nachz ern vesmrn prostor. Do atmosfry lze pidat mraky a molekuly oxidu uhliitho (CO2). Tyto molekuly reprezentuj sklenkov plyny, kter blokuj infraerven svtlo vyzaovan ze Zem. Mraky zase blokuj pichzejc i odchzejc slunen paprsky, co me zpsobovat oteplovn, nebo naopak ochlazovn planety.


JAK TO FUNGUJE?
------------
Sestupujc proudy lutch ipek znzoruj paprsky energie ze slunenho svtla. st svtla je odrena mraky, vznamnj st zen se odr od zemskho povrchu. Pokud je paprsek slunenho svta absorbovn do Zem, zmn se v ervenou teku, kter reprezentuje tepelnou energii. Kad teka odpovd energii z jednoho slunenho paprsku. erven teky se nhodn pohybuj v Zemi, jej teplota je odvozen od celkovho potu tchto teek. Obas se erven teky pemn na infraerven (IR  angl. zkratka infrared) svtlo, unikajc ve form energie vzhru do vesmru. Pravdpodobnost, se kterou dochz k pemn na IR svtlo, zvis na teplot Zem. Pokud je Zem chladn, pouze nkolik mlo ervench teek se promn v IR svtlo; pokud je Zem hork, pak se promuje naopak vtina ervench teek. IR energie je reprezentovna fialovmi ipkami. Kad z nich odpovd stejnmu mnostv energie jako lut ipka nebo erven teka. IR svtlo prochz voln mraky, avak me naret na molekuly CO2.

Existuje zde vztah mezi potem ervench teek v Zemi a jej teplotou. Teplota Zem stoup se vzrstem celkovho mnostv tepeln energie. Tepeln energie je pivdna slunenm svtlem stejn jako paprsky odraenho IR svtla. Tepeln energie tak ubv pi vyzaovn IR svtla ze Zem. Rovnovha mezi tmito vlivy uruje mnostv energie v Zemi, kter proporn odpovd teplot Zem. V tomto modelu je pochopiteln mnoho zjednoduen. Zem nem jednotnou homogenn teplotu, albedo (tzn. schopnost odret energii ze slunenho zen), ani tepelnou kapacitu. Viditeln svtlo je tak sten absorbovno CO2 a nkter paprsky IR svtla mohou naret ve skutenosti na mraky. dn model nen zcela pesn. Podstatn je, e uveden model reaguje v jistch smrech stejn jako systm, kter je tmto modelem reprezentovn. Tento model pedevm ukazuje, jak CO2 a dal plyny absorbujc IR svtlo zpsobuj sklenkov efekt.


JAK MODEL OVLDAT
-------------
Posuvnk SLUNECNI-ZARENI uruje mnostv slunen energie vstupujc do zemsk atmosfry. Hodnota 1.0 odpovd naemu Slunci. Vy hodnoty umouj zkoumat, co by se stalo, pokud by Zem byla ble Slunci nebo pokud by Slunce vce zilo.

Posuvnk ALBEDO uruje, jak mnostv dopadajc slunen energie je absorbovno Zem. Pokud je ALBEDO 1.0, Zem odr veker slunen zen. To se me stt, pokud by Zem zamrzla, co by signalizoval bl povrch planety. Pokud je naopak ALBEDO rovn nule, Zem absorbuje veker slunen zen. Tomu odpovd zase zcela ern povrch. 

Skuten ALBEDO pro na planetu odpovd zhruba hodnot 0.6. Do modelu lze pidvat, nebo z nj naopak odstraovat pomoc pslunch tlatek mraky. Mraky blokuj slunen zen, avak nikoliv IR svtlo.

Dle je zde mon pomoc tlatek pidvat sklenkov plyny, reprezentovan v modelu molekulami CO2. Tento plyn blokuje IR svtlo, ale naopak propout slunen zen. Pomoc tlatek je mon pidvat do modelu CO2 po skupinch 25 molekul a do hodnoty 150. Teplota Zem je zvisl na celkovm mnostv tepla v Zemi. m vce ervench teek vidte, tm je teplej.


VIMNTE SI
----------------
Sledujte jeden samostatn paprsek slunenho zen. Je to snadnj, pokud zpomalte bh modelu pomoc posuvnku v horn sti obrazovky. Mete zrove pout tlatko SLEDUJ PAPRSEK. Co se stane s paprskem po dopadu na Zem? Popite jeho dal cestu. Unikne ze Zem? Co se stane pak? Projdou vechny paprsky touto cestou?


ZKUSTE SI
-------------
1. Hrajte si s modelem. Zmte hodnotu ALBEDO a spuste model. Pidejte do modelu mraky a CO2 a potom sledujte jeden samostatn slunen paprsek. Jak je nejvy teplota Zem, kter takto dokete doshnout?

2. Spuste model se siln zcm Sluncem, avak zcela bez mrak a CO2. Co se v takovm ppad dje s teplotou? Mla by nejdve prudce vzrst a pot se usadit na hodnot kolem 50 stup. Pro pestane rst? Pro dochz k dalm teplotnm vkyvm? Nezapomnejte, e teplota odpovd mnostv ervench teek v Zemi. Pokud je teplota konstantn, je v modelu zhruba stejn mnostv pichzejcch slunench a odchzejcch IR paprsk. Pro?

3. Prozkoumejte dopady nastaven hodnoty ALBEDO pi fixaci vech ostatnch hodnot. Zpsobuje vzrst tto hodnoty zven nebo naopak snen teploty Zem? Pi vaem experimentovn se ujistte, e jste nechali bet model dostaten dlouho na to, aby dolo k ustlen teploty.

4. Vyzkouejte si, jak model reaguje na pidn mrak, pokud zanechte vechny ostatn vlivy konstantn.

5. Zkuste do modelu pidat 100 molekul CO2. Co zpsob zmnu, kterou pot pozorujete? Sledujte zpomalen jeden slunen paprsek.


ROZEN MODELU
-------------------
Pokuste se do modelu pidat nkter dal faktory, kter mohou ovlivovat teplotu Zem. Napklad mete pidat polka s rostlinstvem a pot pozorovat, co se stane, pokud lovk tuto vegetaci spotebuje pro sv ely. Nebo mete do modelu pidat promnliv albedo, aby nefungovalo jako jedin hodnota pro celou planetu. Mohou zde bt ledovce s vysokou hodnotou, nebo naopak moe s nzkou hodnotou albeda. Pak by bylo mon odhadovat, k emu bude dochzet pi tn ledovc do moe.


PROGRAMOVAC ZAJMAVOSTI NETLOGA
----------------
Vimnte si, e mraky jsou ve skutenosti tvoeny mnostvm malch kulatch elv (turtles).


SOUVISEJC MODELY
--------------
Daisyworld (Svt sedmikrsek)


PODKOVN A ODKAZY
----------------------
Tento model je zaloen na star verzi, vytvoen v roce 2005 Robertem Tinkerem v rmci projektu TELS.

Pi citovn tohoto modelu ve vdeckch publikacch pouijte prosm nsledujc odkaz: Tinker, R. and Wilensky, U. (2007). NetLogo Climate Change model. http://ccl.northwestern.edu/netlogo/models/ClimateChange. Center for Connected Learning and Computer-Based Modeling, Northwestern University, Evanston, IL.

V jinch publikacch uvete prosm tyto informace: Copyright 2007 Uri Wilensky. All rights reserved. Pro dal informace viz http://ccl.northwestern.edu/netlogo/models/ClimateChange.

@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cloud
false
0
Circle -7500403 true true 13 118 94
Circle -7500403 true true 86 101 127
Circle -7500403 true true 51 51 108
Circle -7500403 true true 118 43 95
Circle -7500403 true true 158 68 134

co2-molecule
true
0
Circle -1 true false 183 63 84
Circle -16777216 false false 183 63 84
Circle -7500403 true true 75 75 150
Circle -16777216 false false 75 75 150
Circle -1 true false 33 63 84
Circle -16777216 false false 33 63 84

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

molecule water
true
0
Circle -1 true false 183 63 84
Circle -16777216 false false 183 63 84
Circle -7500403 true true 75 75 150
Circle -16777216 false false 75 75 150
Circle -1 true false 33 63 84
Circle -16777216 false false 33 63 84

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

ray
true
0
Line -7500403 true 150 0 150 315
Line -7500403 true 120 255 150 225
Line -7500403 true 150 225 180 255
Line -7500403 true 120 165 150 135
Line -7500403 true 120 75 150 45
Line -7500403 true 150 135 180 165
Line -7500403 true 150 45 180 75

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 4.0.3
@#$#@#$#@
setup add-cloud add-cloud add-cloud repeat 800 [ go ]
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

@#$#@#$#@
